﻿//////////////////////////////////////////////
// Image.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkImages
{
	class Image ;
	class ImageView ;
}

namespace nkWinUi
{
	class System ;

	struct ImageData ;
}

/// Standards --------------------------------

// nkWinUi
#include "../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Containers/String.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------

namespace nkWinUi
{
	class DLL_WINUI_EXPORT Image
	{			
		public :

			// Constructor, destructor
			Image () noexcept ;
			virtual ~Image () ;

			// Getters
			virtual unsigned int getWidth () const = 0 ;
			virtual unsigned int getHeight () const = 0 ;
			nkMemory::StringView getName () const ;
			bool getHidden () const ;

			// Setters
			void setName (nkMemory::StringView value) ;
			void setHidden (bool value) ;
			void setFromImage (const nkImages::ImageView& image) ;
			void setFromImageCopy (const nkImages::ImageView& image) ;
			void setFromImageForward (nkImages::Image&& image) ;

			// Loading
			virtual bool load () = 0 ;
			virtual void unload () = 0 ;
			bool reload () ;

		public :

			// Statics
			static nkMemory::UniquePtr<Image> create (System* system = nullptr) ;

		protected :

			// Helpers
			nkImages::ImageView _getImageData () ;

		protected :

			// Attributes
			nkMemory::String _name ;
			nkMemory::UniquePtr<ImageData> _imageData ;

			bool _hidden ;
	} ;
}